procedure $see_extra
argument local string scalar runno
argument local namelist freqs
argument local numeric series by case agelower = list(16,25,16,18,20,25,30,35,40,45,50,55,60,62,65,70)
argument local numeric series by case ageupper = list(80,80,17,19,24,29,34,39,44,49,54,59,61,64,69,80)
argument local string scalar db_path = ""
argument local string scalar pro_path = ""
block

   device graphics postp

   thickness medium 3
   thickness thick 10

   legend contents description off 
   legend size small

   map color postscript C7  "505C5C", c9  "F30E0E", C10 "D40E2E", C11 "B50E4F", &&
                        C12 "970E70", C13 "780E90", C14 "5A0EB1", C15 "3B0ED2", &&
                        C16 "1D0EF3", c6 "dimgray"

   plot color #1  c1,  #2  c9,  #3  c11, #4  c13,#5  c15, &&
              #6  c16, #7  c1,  #8  c1,  #9  c9, #10 c11, &&
              #11 c13, #12 c15, #13 c16, #14 c1
   plot style #1  solid,  #2  solid,  #3  solid,  #4  solid,  #5  solid, &&
              #6  solid,  #7  solid,  #8  dashed, #9  dashed, #10 dashed, &&
              #11 dashed, #12 dashed, #13 dashed, #14 dashed

   if missing(location(@open.db,"LOUT"))
      open <ac re> file(local'db_path+"lfpr_run"+local'runno+".db") as lout
      -local'loutopened = TRUE
   else
      -local'loutopened = FALSE
   end if

   if missing(location(@open.db,"CPSREV"))
      open <ac re> file(local'db_path+"cpscovar_rev.db") as cpsrev
      -local'cpsrevopened = TRUE
   else
      -local'cpsrevopened = FALSE
   end if

   local'filename = "$TMPDIR/mg_"+$USERID()+"_"+left(system("date +'%Y%m%d%H%M%S%N'"),20)+".db"

   cload file(local'pro_path+"workagg.pro")
   $workagg local'freqs, local'agelower, local'ageupper, local'runno, local'filename

   open <ac re> file(trim(local'filename)) as todb

   loop for sfreq in local'freqs
      -local'ssfreq = (if name(sfreq) eq "M" then "" else name(sfreq))

      open <ac over; kind graphic> file("run"+local'runno+"extra_"+name(sfreq)+".ps") as extra.ps
      channel graphics extra.ps
      channel reports extra.ps

      loop for GG in {m,f}
         page title area length standard
         page title lines justify heightwise top
         page title #1 center size med, text "LFPR Trends(" + (if name(GG) EQ "M" then "Male" else "Female")  + ")"

         plot color #1 C9, #2 C10, #3 C11, #4 C12, #5 C13, #6 C14, #7 C15, #8 C16
         plot style #1 solid, #2 dashed, #3 solid, #4 dashed, #5 solid, #6 dashed, #7 solid, #8 dashed 
         page divi rows 2, columns 1
         loop for AA = 16 to 72 step 8
            cell(((AA div 8) mod 2)+1,1)
            graph
               date * to *
               legend size xsmall, fill horizontal
               legend division row 2, column auto
               data lout'id(lout'lfpname+"_mod"+name(GG)+string(AA)+name(sfreq)) <plot name "Age "+string(AA)>, &&
                    lout'id(lout'lfpname+"_mod"+name(GG)+string(AA+1)+name(sfreq)) <plot name "Age "+string(AA+1)>, &&
                    lout'id(lout'lfpname+"_mod"+name(GG)+string(AA+2)+name(sfreq)) <plot name "Age "+string(AA+2)>, &&
                    lout'id(lout'lfpname+"_mod"+name(GG)+string(AA+3)+name(sfreq)) <plot name "Age "+string(AA+3)>, &&
                    lout'id(lout'lfpname+"_mod"+name(GG)+string(AA+4)+name(sfreq)) <plot name "Age "+string(AA+4)>, &&
                    lout'id(lout'lfpname+"_mod"+name(GG)+string(AA+5)+name(sfreq)) <plot name "Age "+string(AA+5)>, &&
                    lout'id(lout'lfpname+"_mod"+name(GG)+string(AA+6)+name(sfreq)) <plot name "Age "+string(AA+6)>, &&
                    lout'id(lout'lfpname+"_mod"+name(GG)+string(AA+7)+name(sfreq)) <plot name "Age "+string(AA+7)>
            end graph
         end loop

         plot color #1 c1, #2 C9, #3 c16   
         plot style #1 solid, #2 solid, #3 solid

         page title area length standard
         page title lines justify heightwise top
         page title #1 center size med, text "LFPR Trends(" + (if name(GG) EQ "M" then "Male" else "Female")  + ")"

         page divi rows 4, columns 2
         loop for AA = 16 to 79
            legend size xsmall
            cell(((AA MOD 8) div 2)+1, ((AA MOD 8) MOD 2)+1)
            graph
               date * to *
               title #1 size med, text "Age ("+string(AA)+")"
               legend divi row 2, column auto
               data cpsrev'id(lout'lfpname+name(GG)+"_a"+string(AA)+local'ssfreq) <plot name "Actual SA",c6, style solid>, &&
                    lout'id(lout'lfpname+"_mod"+name(GG)+string(AA)+name(sfreq)) <plot name "Trend", color blue>, &&
                    lout'id(lout'lfpname+"_pred"+name(GG)+string(AA)+name(sfreq)) <plot name "Predicted", color red>
            end graph
         end loop

         loop for grp = 1 to lastvalue(local'agelower) step 2
            page divi rows 2, columns 1
            legend size xsmall

            loop for grpx = grp to grp+lmin(lastvalue(local'agelower)-grp,1)
               -local'thisgroup = "a"+string(local'agelower[grpx])+(if ageupper[grpx] EQ 80 then "P" else "t"+string(ageupper[grpx]))
               cell(grpx-grp+1,1)
               graph	
                  thickness xthin 1, thin 3, medium 6, thick 9, xthick 12 
                  plot color #1 C7, #2 black, #3 blue, #4 red
                  plot style #1 solid, #2 solid, #3 solid, #4 solid
                  plot thickness #1 xthin, #2 xthin, #3 medium, #4 xthin

                  date * to *
                  title #1 size med, text ""+(if name(GG) EQ "M" then "Male" else "Female")+" - Age ("+thisgroup+")"
                  legend divi row 2, column auto
                  try 
                     data 100*todb'id(lout'lfpname+name(GG)+"_"+thisgroup+local'ssfreq) <plot name "Age Aggregated (SA)">, &&
                          100*todb'id("mod"+name(GG)+"_"+thisgroup+name(sfreq)) <plot name "Trend">, &&
                          100*todb'id("pred"+name(GG)+"_"+thisgroup+name(sfreq)) <plot name "Fitted/Simulated">
                  otherwise
                     data convert(100*todb'id("lfpr"+name(GG)+"_"+thisgroup),q,linear,averaged) <plot name "Published">, &&
                          100*todb'id(lout'lfpname+name(GG)+"_"+thisgroup+local'ssfreq) <plot name "Age Aggregated (SA)">, &&
                          100*todb'id("mod"+name(GG)+"_"+thisgroup+name(sfreq)) <plot name "Trend">, &&
                          100*todb'id("pred"+name(GG)+"_"+thisgroup+name(sfreq)) <plot name "Fitted/Simulated">
                  end try
               end graph
            end loop		  
         end loop

         refresh
      end loop -- end gender loop

      close extra.ps
      execute "!(ps2pdf run"+local'runno+"extra_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"extra_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"extra_"+name(sfreq)+".ps)&"

   end loop

   if (not missing(location(@open.db,"TODB")))
      close todb
      system "rm -f "+trim(local'filename)
   end if

   if local'cpsrevopened
      close cpsrev
   end if

   if local'loutopened
      close lout
   end if

end block
end procedure
